/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.superplan;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Actiongram;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.MaterialQuantity;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.store.InPlanPtnStoreActivity;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.store.StoreActivityFactory;
import cz.insophy.inplan.store.StoreActivityOwner;
import cz.insophy.inplan.store.TransactionStoreActivityTarget;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import cz.insophy.inplan.superplan.ProductionTreeNode;
import cz.insophy.inplan.superplan.ProductionTreeVisitor;
import cz.insophy.inplan.superplan.RelatedActivitiesCollector;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.Identifiable;
import cz.insophy.inplan.util.Localizer;
import cz.insophy.inplan.util.UserSelectable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class GeneralizedOrderRequest
extends GeneralizedRequest
implements UserSelectable,
StoreActivityOwner,
TransactionStoreActivityTarget,
Identifiable {
    private String id;
    private Plan plan;
    private final List<GeneralizedActionRequest> gars;
    private List<InPlanPtnStoreActivity> storeActivities;
    private boolean userSelected;
    private int priority = 10;
    private final Product product;
    private State state;
    private Actiongram actiongram;
    private boolean actiongramLocked;

    public GeneralizedOrderRequest(String id, Product product, double requestedQty, long releaseDate, long dueDate) {
        this(id, product, requestedQty, releaseDate, dueDate, State.PLANNING);
    }

    public GeneralizedOrderRequest(String id, Product product, double requestedQty, long releaseDate, long dueDate, State state) {
        super(requestedQty, releaseDate, dueDate);
        this.id = id;
        this.product = product;
        this.userSelected = false;
        this.gars = new ArrayList<GeneralizedActionRequest>();
        this.userSelected = true;
        this.state = state;
        this.actiongram = null;
        this.updateSummaryData();
        this.storeActivities = Lists.newArrayList();
    }

    @Override
    public void unsafeAddChild(ProductionTreeNode child) {
        if (!(child instanceof GeneralizedActionRequest)) {
            throw new UnsupportedOperationException("Invalid type of PTN passed: " + child.getClass());
        }
        this.unsafeAddGar((GeneralizedActionRequest)child);
    }

    @Override
    public boolean unsafeRemoveChild(ProductionTreeNode child) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public long getTimeToMake() {
        if (!this.hasSelectedActiongram()) {
            return 0L;
        }
        return this.getSelectedActiongram().getTimeToMake(this.getRequestedQty());
    }

    public long getRemainingTimeToMake() {
        return this.getRemainingTimeToMake(false);
    }

    public long getRemainingTimeToMake(boolean includePrepareTime) {
        long rttm = 0L;
        for (GeneralizedActionRequest gar : this.gars) {
            double qty = Math.max(0.0, gar.getRequestedQty() - gar.getOutOfPlanQty());
            if (!(qty > 1.0E-7)) continue;
            rttm += gar.getAction().timeToMake(qty);
            if (!includePrepareTime) continue;
            rttm += gar.getAction().getMinTimeToPrepare();
        }
        return rttm;
    }

    public long getNormtime() {
        if (!this.hasSelectedActiongram()) {
            return 0L;
        }
        return this.getSelectedActiongram().getNormtime(this.getRequestedQty());
    }

    public long getRemainingNormtime() {
        long normtime = 0L;
        for (GeneralizedActionRequest gar : this.gars) {
            double qty = Math.max(0.0, gar.getRequestedQty() - gar.getOutOfPlanQty());
            normtime += gar.getAction().normtime(qty);
        }
        return normtime;
    }

    @Override
    public void accept(ProductionTreeVisitor visitor, boolean childrenFirst) {
        if (!childrenFirst) {
            visitor.visit(this);
        }
        for (GeneralizedActionRequest gar : this.gars) {
            gar.accept(visitor, childrenFirst);
        }
        if (childrenFirst) {
            visitor.visit(this);
        }
    }

    @Override
    @Nonnull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (this.getSuperplan() == null) {
            this.id = id;
            return;
        }
        if (!this.getSuperplan().unsafeRenameGor(this, this.id, id)) {
            throw new IllegalStateException("GOR " + this + " has a parent superplan but that does not contain this GOR.");
        }
        this.id = id;
    }

    @Override
    public boolean isUserSelected() {
        return this.userSelected;
    }

    @Override
    public void setUserSelected(boolean selected) {
        this.userSelected = selected;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public void updateSummaryData() {
        if (!this.hasSelectedActiongram()) {
            this.unsafeSetOutOfPlanQty(0.0);
            this.unsafeSetInPlanQty(0.0);
            this.unsafeSetTotalPlannedQty(0.0 + this.getOutOfPlanQty());
            this.unsafeSetTotalRequestedQty(this.getRequestedQty());
            this.unsafeSetTotalCompletedQty(this.getTotalCompletedQty());
        } else {
            GeneralizedActionRequest lastGar = this.gars.get(this.gars.size() - 1);
            this.unsafeSetOutOfPlanQty(lastGar.getOutOfPlanQty() / lastGar.getAction().getQtyCoef());
            this.unsafeSetInPlanQty(lastGar.getInPlanQty() / lastGar.getAction().getQtyCoef());
            double totalR = 0.0;
            double totalP = 0.0;
            double totalC = 0.0;
            for (GeneralizedActionRequest gar : this.gars) {
                double totalPlanned = gar.getTotalPlannedQty();
                if (totalPlanned > gar.getTotalRequestedQty()) {
                    totalPlanned = gar.getTotalRequestedQty();
                }
                totalR += gar.getTotalRequestedQty();
                totalP += totalPlanned;
                totalC += gar.getTotalCompletedQty();
            }
            this.unsafeSetTotalPlannedQty(totalP);
            this.unsafeSetTotalRequestedQty(totalR);
            this.unsafeSetTotalCompletedQty(totalC);
        }
        this.changeStoreActQties();
    }

    @Override
    public void updateStartEnd() {
        long endDate = Long.MIN_VALUE;
        long startDate = Long.MAX_VALUE;
        long plannedDuration = 0L;
        for (GeneralizedActionRequest gar : this.gars) {
            if (gar.getEndDate() > endDate && GeneralizedRequest.isDateValid(gar.getEndDate())) {
                endDate = gar.getEndDate();
            }
            if (gar.getStartDate() < startDate && GeneralizedRequest.isDateValid(gar.getStartDate())) {
                startDate = gar.getStartDate();
            }
            plannedDuration += gar.getPlannedDuration();
        }
        this.unsafeSetStartDate(startDate);
        this.unsafeSetEndDate(endDate);
        this.unsafeSetPlannedDuration(plannedDuration);
    }

    @Override
    public Superplan getSuperplan() {
        return ProductionTreeAlgorithms.getSuperplan(this);
    }

    public List<? extends ProductionTreeNode> removeRelatedActivities() {
        return ProductionTreeAlgorithms.removeRelatedActivities(this);
    }

    public String toString() {
        return String.format("GOR(%s, %f, %f)", this.id, this.getRequestedQty(), this.getPlannedQty());
    }

    public Product getProduct() {
        return this.product;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public boolean isFixed() {
        Superplan superplan = this.getSuperplan();
        if (superplan == null) {
            return false;
        }
        return this.getState() == State.RUNNING || this.getStartDate() < superplan.getFixationDate() || this.getState() == State.WILL_BE_RELEASED;
    }

    public long getMaxDdRdDiff() {
        if (this.gars.isEmpty()) {
            return 0L;
        }
        long max = Long.MIN_VALUE;
        for (GeneralizedActionRequest gar : this.gars) {
            long diff = gar.getDueDate() - gar.getReleaseDate();
            if (diff <= max) continue;
            max = diff;
        }
        return max;
    }

    @Override
    protected void unsafeSetStartDate(long startDate) {
        super.unsafeSetStartDate(startDate);
        Superplan superplan = this.getSuperplan();
        boolean startBeforeFixation = superplan != null && GeneralizedOrderRequest.isDateValid(this.getStartDate()) && superplan.getFixationDate() > this.getStartDate();
        switch (this.state) {
            case PLANNING: {
                if (!startBeforeFixation) break;
                this.setState(State.WILL_BE_RELEASED);
                break;
            }
            case WILL_BE_RELEASED: {
                if (startBeforeFixation) break;
                this.setState(State.PLANNING);
                break;
            }
        }
    }

    @Override
    public double getTotalPlannedQty() {
        return super.getTotalPlannedQty();
    }

    @Override
    public double getTotalRequestedQty() {
        return super.getTotalRequestedQty();
    }

    @Override
    public long getStartDate() {
        return super.getStartDate();
    }

    @Override
    public long getEndDate() {
        return super.getEndDate();
    }

    @Override
    public long getPlannedDuration() {
        return super.getPlannedDuration();
    }

    public Plan getPlan() {
        return this.plan;
    }

    @Override
    public void setPlan(Plan plan) {
        if (plan != null && this.plan != null) {
            throw new IllegalStateException("GOR cannot be assigned to two plans at the same time.");
        }
        this.removeStoreActivitiesFromPlan();
        this.plan = plan;
        this.addStoreActivitiesToPlan();
        for (GeneralizedActionRequest gar : this.gars) {
            gar.setPlan(plan);
        }
        if (this.plan != null) {
            this.setProperties(null, this.plan.getShopConf().getPropertyDefinitionsInfoFor(GeneralizedOrderRequest.class));
        }
    }

    public List<InPlanPtnStoreActivity> getStoreActivities() {
        return this.storeActivities;
    }

    private Actiongram getActiongram() {
        if (this.actiongram == null) {
            return this.product.getDefaultActiongram();
        }
        return this.actiongram;
    }

    public Actiongram getSelectedActiongram() {
        return this.actiongram;
    }

    public double getMaterialQty(Material material) {
        double qty = this.getActiongram().getMaterialQty(material);
        return material.isConstant() ? qty : qty * this.getRequestedQty();
    }

    public double getProducingQty(Material material) {
        double qty = this.getActiongram().getProducingQty(material);
        return material.isConstant() ? qty : qty * this.getRequestedQty();
    }

    public boolean hasSelectedActiongram() {
        return this.actiongram != null;
    }

    public void unsafeSetActiongram(Actiongram actiongram) {
        if (this.hasSelectedActiongram()) {
            throw new IllegalStateException("The GOR has already one actiongram chosen, delete it first.");
        }
        if (!this.isFeasible(actiongram)) {
            throw new IllegalArgumentException(String.format("Alternative actiongram %s not feasible for Product %s", actiongram, this.product));
        }
        this.actiongram = actiongram;
        if (actiongram != null) {
            for (Action action : actiongram.getActions()) {
                this.unsafeAddGar(new GeneralizedActionRequest(action, this.getRequestedQty(), this.getReleaseDate(), this.getDueDate()));
            }
            this.createStoreActivities();
            this.addStoreActivitiesToPlan();
        }
    }

    @Deprecated
    public void unsafeChooseActiongram(Actiongram actiongram) {
        this.unsafeSetActiongram(actiongram);
    }

    public void unsafeCancelActiongram() {
        if (!RelatedActivitiesCollector.collectFrom(this).isEmpty()) {
            throw new IllegalStateException("Actiongram not empty, delete the AAs first.");
        }
        for (GeneralizedActionRequest gar : this.gars) {
            gar.setPlan(null);
        }
        this.actiongram = null;
        this.gars.clear();
        this.destroyStoreActivites();
    }

    public List<GeneralizedActionRequest> getGars() {
        if (this.hasSelectedActiongram()) {
            return Collections.unmodifiableList(this.gars);
        }
        return Collections.emptyList();
    }

    public void unsafeAddGar(GeneralizedActionRequest gar) {
        this.gars.add(gar);
        gar.unsafeSetParent(this);
    }

    public boolean isFeasible(Actiongram actiongram) {
        for (Actiongram feasibleAg : this.product.getActiongrams()) {
            if (!feasibleAg.equals(actiongram)) continue;
            return true;
        }
        return false;
    }

    public GeneralizedActionRequest getGar(String actionName) {
        if (this.getSelectedActiongram() == null) {
            return null;
        }
        for (GeneralizedActionRequest gar : this.gars) {
            if (!gar.getAction().getName().equals(actionName)) continue;
            return gar;
        }
        return null;
    }

    public void setActiongramLocked(boolean actiongramLocked) {
        this.actiongramLocked = actiongramLocked;
    }

    public boolean isActiongramLocked() {
        return this.actiongramLocked;
    }

    public void cancelActiongram() {
        if (this.isActiongramLocked()) {
            throw new IllegalArgumentException("Actiongram is locked.");
        }
        this.cancelActiongramNoCheck();
    }

    protected void cancelActiongramNoCheck() {
        ProductionTreeAlgorithms.cancelGorActiongram(this);
    }

    public void setActiongram(Actiongram actiongram) {
        ProductionTreeAlgorithms.chooseGorActiongram(this, actiongram);
    }

    @Deprecated
    public void chooseActiongram(Actiongram actiongram) {
        this.setActiongram(actiongram);
    }

    private void destroyStoreActivites() {
        this.removeStoreActivitiesFromPlan();
        this.storeActivities.clear();
    }

    private void createStoreActivities() {
        if (this.actiongram == null || this.getReleaseDate() == -9223372036854775708L || this.getDueDate() == -9223372036854775708L) {
            return;
        }
        this.storeActivities = StoreActivityFactory.createStoreActivities(this);
    }

    private void addStoreActivitiesToPlan() {
        if (this.plan != null && !this.isStoreActivitiesInPlan()) {
            for (StoreActivity storeActivity : this.storeActivities) {
                this.plan.addActivity(storeActivity);
            }
        }
    }

    private void removeStoreActivitiesFromPlan() {
        if (this.plan != null && this.isStoreActivitiesInPlan()) {
            for (StoreActivity storeActivity : this.storeActivities) {
                this.plan.removeActivity(storeActivity);
            }
        }
    }

    private void moveStoreActivities() {
        if (this.isStoreActivitiesAligned()) {
            return;
        }
        for (StoreActivity storeActivity : this.storeActivities) {
            if (storeActivity.getQty() < 0.0) {
                storeActivity.setTime(this.getReleaseDate());
                continue;
            }
            storeActivity.setTime(this.getDueDate());
        }
    }

    private boolean isStoreActivitiesAligned() {
        if (this.storeActivities == null) {
            return true;
        }
        long start = this.getReleaseDate();
        long end = this.getDueDate();
        for (StoreActivity storeActivity : this.storeActivities) {
            if (storeActivity.getQty() < 0.0 && storeActivity.getTime() != start) {
                return false;
            }
            if (!(storeActivity.getQty() >= 0.0) || storeActivity.getTime() == end) continue;
            return false;
        }
        return true;
    }

    private boolean isStoreActivitiesInPlan() {
        if (this.storeActivities == null || this.storeActivities.isEmpty()) {
            return true;
        }
        Plan saPlan = this.storeActivities.get(0).getPlan();
        for (StoreActivity storeActivity : this.storeActivities) {
            if (storeActivity.getPlan() == saPlan) continue;
            throw new IllegalArgumentException("Illegal state of GOR store activities: some are in a plan and some are not.");
        }
        return saPlan != null;
    }

    private void changeStoreActQties() {
        if (this.storeActivities == null) {
            return;
        }
        this.removeStoreActivitiesFromPlan();
        this.storeActivities.clear();
        this.createStoreActivities();
        this.addStoreActivitiesToPlan();
    }

    @Override
    public void unsafeSetDueDate(long dueDate) {
        if (this.getDueDate() != -9223372036854775708L) {
            this.removeStoreActivitiesFromPlan();
        }
        super.unsafeSetDueDate(dueDate);
        this.moveStoreActivities();
        if (dueDate != -9223372036854775708L) {
            this.addStoreActivitiesToPlan();
        }
    }

    @Override
    public void unsafeSetReleaseDate(long releaseDate) {
        if (this.getReleaseDate() != -9223372036854775708L) {
            this.removeStoreActivitiesFromPlan();
        }
        super.unsafeSetReleaseDate(releaseDate);
        this.moveStoreActivities();
        if (releaseDate != -9223372036854775708L) {
            this.addStoreActivitiesToPlan();
        }
    }

    @Override
    public void unsafeSetRequestedQty(double requestedQty) {
        super.unsafeSetRequestedQty(requestedQty);
        this.changeStoreActQties();
    }

    public void setReleaseDate(long releaseDate, boolean updateGars) {
        this.unsafeSetReleaseDate(releaseDate);
        if (updateGars) {
            for (GeneralizedActionRequest gar : this.gars) {
                gar.unsafeSetReleaseDate(releaseDate);
            }
        }
    }

    public void setReleaseDate(long releaseDate) {
        this.setReleaseDate(releaseDate, true);
    }

    public void setDueDate(long dueDate, boolean updateGars) {
        this.unsafeSetDueDate(dueDate);
        if (updateGars) {
            for (GeneralizedActionRequest gar : this.gars) {
                gar.unsafeSetDueDate(dueDate);
            }
        }
    }

    public void setDueDate(long dueDate) {
        this.setDueDate(dueDate, true);
    }

    @Override
    protected void unsafeSetTotalRequestedQty(double totalRequestedQty) {
        super.unsafeSetTotalRequestedQty(totalRequestedQty);
    }

    public static enum State {
        PROPOSED,
        PLANNING,
        RELEASED,
        RUNNING,
        WILL_BE_RELEASED,
        VIRTUAL,
        PAUSED;


        public String getLabel() {
            return Localizer.getString("gor.state." + this.name().toLowerCase());
        }
    }

    public static final class Limits {
        public static final long MAX_GOR_PROD_TIME = 315360000000L;
        private final Map<Actiongram, Double> okQties = new IdentityHashMap<Actiongram, Double>();

        public boolean isProductQtyValid(double qty, @Nonnull Product product) {
            Preconditions.checkNotNull(product, "Product cannot be null.");
            for (Actiongram ag : product.getActiongrams()) {
                if (!this.isActiongramQtyValid(qty, ag)) continue;
                return true;
            }
            return false;
        }

        public boolean isActiongramQtyValid(double qty, @Nonnull Actiongram ag) {
            Preconditions.checkNotNull(ag, "Actiongram cannot be null.");
            Double cachedOkQty = this.okQties.get(ag);
            if (cachedOkQty != null && qty <= cachedOkQty) {
                return true;
            }
            try {
                if (ag.getTimeToMake(qty, true) > 315360000000L) {
                    return false;
                }
                for (Action a : ag.getActions()) {
                    for (MaterialQuantity mq : a.getBom()) {
                        if (!(mq.getMaterial() instanceof Product)) continue;
                        Product product = (Product)mq.getMaterial();
                        boolean subprodOk = false;
                        for (Actiongram subAg : product.getActiongrams()) {
                            subprodOk = subprodOk || this.isActiongramQtyValid(qty * mq.getQty(), subAg);
                        }
                        if (subprodOk) continue;
                        return false;
                    }
                }
                this.okQties.put(ag, qty);
                return true;
            }
            catch (ArithmeticException exception) {
                return false;
            }
        }
    }
}

